package GUI;


import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import baseClass.*;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

/**
 * @author Carlos Victor 
 */
public class JanelaSemelhantes implements MouseListener, ActionListener {

	private JFrame window = null;
	private JPanel panel1 = null;
	private JButton button1,button2,button3,button4= null;
	private JLabel label1,label2,label3 = null;
	private JComboBox comboBox = null;
	private Recomendacoes recomendacoes = null;
	private JTextArea txt = null;
	private Component comp = null; 
	private JLabel label6 = null;
	private JComboBox comboBox2 = null;
	  
	/**
	 * Cria uma nova janela de sistema de recomendacoes
	 * @param opinioes
	 * 		O caminho do arquivo de opinioes.
	 * @param enderecos
	 * 		O caminho do arquivo de enderecos.
	 */
	public JanelaSemelhantes(Recomendacoes recomendacoes) {
		
		this.recomendacoes = recomendacoes;
		
		createWindow();
	}
	
	/**
	 * Criacao da janela.
	 */
	private void createWindow() {
		window = new JFrame();
		panel1 = new JPanel();
		button1 = new JButton("Ok");
		button2 = new JButton("Voltar");
		button3 = new JButton("Ajuda");
		button4 = new JButton("Gerar semelhantes");
		label1 = new JLabel("SEJA BEM VINDO AO SISTEMA DE RECOMEDAÇÕES.");
		label2 = new JLabel("NOME DO USUÁRIO");
		label3 = new JLabel("USUÁRIOS SEMELHANTES");
		label6 = new JLabel(); 
		comboBox = new JComboBox();
		comboBox2 = new JComboBox();
		txt = new JTextArea();
		comp = new JScrollPane(txt); 
			
		window.setSize(700, 600);
		window.setResizable(true);
		window.setMinimumSize(new Dimension(300, 200));
		window.setLocation(280, 60);
		window.setVisible(true);
		window.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		label6.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/image3101-v3.png")));
		label6.setLocation(0, -150);
		label6.setSize(550,470);
		label1.setLocation(340, -100);
		label1.setSize(300, 300);
		label1.setForeground(Color.WHITE);
		label2.setLocation(440, 20);
		label2.setSize(300, 300);
		label2.setForeground(Color.WHITE);
		label3.setLocation(430, 150);
		label3.setSize(300, 300);
		label3.setForeground(Color.WHITE);
		
		
		panel1.setVisible(true);
		panel1.setLayout(null);
		panel1.setBackground(Color.ORANGE);
		
		button1.setToolTipText("Carrega recomendações");
		button1.setEnabled(true);
		button1.addMouseListener(this);
		button1.addActionListener(this);
		button1.setLocation(380,500);
		button1.setSize(100,20);
		button1.setForeground(Color.ORANGE);
		button2.setToolTipText("Voltar ao menu principal");
		button2.setEnabled(true);
		button2.addMouseListener(this);
		button2.addActionListener(this);
		button2.setSize(100,20);
		button2.setLocation(520, 500);
		button2.setForeground(Color.ORANGE);
		button3.setToolTipText("Tutorial sobre o sistema.");
		button3.setEnabled(true);
		button3.addMouseListener(this);
		button3.addActionListener(this);
		button3.setSize(100,20);
		button3.setLocation(434, 90);
		button3.setForeground(Color.ORANGE);
		button4.setToolTipText("Carregar usuários com gostos semelhantes");
		button4.setEnabled(true);
		button4.addMouseListener(this);
		button4.addActionListener(this);
		button4.setSize(150,20);
		button4.setLocation(420,450);
		button4.setForeground(Color.ORANGE);
		
		
		
		comp.setSize(300, 400);
		comp.setLocation(20, 150);
		txt.setEnabled(false);
	
		comboBox.setToolTipText("Usuários semelhantes");
		comboBox.setLocation(400, 330);
		comboBox.setSize(200, 20);
		comboBox.setForeground(Color.ORANGE);
	
		for (User user : recomendacoes.getUsuarios()) {
			comboBox2.addItem(user.getNome());
		}
		
		comboBox2.setLocation(400, 200);
		comboBox2.setSize(200, 20);
		comboBox2.setForeground(Color.ORANGE);
		
		panel1.add(label1);
		panel1.add(label2);
		panel1.add(label3);
		panel1.add(button1);
		panel1.add(button2);
		panel1.add(button3);
		panel1.add(button4);
		panel1.add(comboBox);
		panel1.add(comboBox2);
		panel1.add(label6);
		panel1.add(comp);
		window.add(panel1);
	}

	/**
	 * M�todos referentes ao MouseListenner
	 */
	public void mouseClicked(MouseEvent arg0) {
	}
	
	public void mouseEntered(MouseEvent arg0) {
	}
	
	public void mouseExited(MouseEvent arg0) {
	}

	public void mousePressed(MouseEvent arg0) {
	}

	public void mouseReleased(MouseEvent arg0) {
	}

	/**
	 * Metodo referente ao ActionListener
	 */
	public void actionPerformed(ActionEvent e) {
		
		if (e.getSource() == button1) {
			txt.setText("");
			
			for (User u : recomendacoes.getUsuarios()) {
				if (u.getNome().equals(comboBox.getSelectedItem())) {
					txt.append(recomendacoes.getOpinioesDeSemelhante(u));
				}
			}
			
		}		
				
		if (e.getSource() == button2) {
			window.dispose();
			new MenuRecomendacoes(recomendacoes.getCaminhoArquivo2(), recomendacoes.getCaminhoArquivo1());
		}
		
		if (e.getSource() == button3) {
			JOptionPane.showMessageDialog(null, "RECOMENDAÇÕES POR SEMELHANÇA\nESCOLHA UM USUÁRIO E PRESSIONE EM GERAR SEMELHANÇA, VAI GERAR UMA LISTA DE USUÁRIOS ORGANIZADOS DO DE MAIOR SEMELHANÇA PARA O DE MENOR\nPRESSIONE 'OK' PARA VER AS OPINIÕES DO USUÁRIO SEMELHANTE A VOCÊ\nPRESSIONE VOLTAR PARA RETORNAR AO MENU PRINCIPAL");
		}
		
		if (e.getSource() == button4) {
			comboBox.removeAllItems();
			for (User usuario : recomendacoes.getUsuarios()) {
				if (usuario.getNome().equals(comboBox2.getSelectedItem())) {
					try {
						for (User user : usuario.getSemelhantes(recomendacoes.getUsuarios())) {
							comboBox.addItem(user.getNome());
						}
					} catch (Exception e1) {
						e1.printStackTrace();
					}
				}
			}
		}

	
	}
}
